#include "stm32f10x.h"
#include <stdio.h>
#include "wiz_platform.h"
#include "wizchip_conf.h"
#include "wiz_interface.h"
#include "UPnP.h"

/*wizchip->STM32 Hardware Pin define*/
//	wizchip_SCS    --->     STM32_GPIOD7
//	wizchip_SCLK	 --->     STM32_GPIOB13
//  wizchip_MISO	 --->     STM32_GPIOB14
//	wizchip_MOSI	 --->     STM32_GPIOB15
//	wizchip_RESET	 --->     STM32_GPIOD8
//	wizchip_INT    --->     STM32_GPIOD9

/* The current routine uses a 12Mhz external crystal. If you use other crystals, you need to modify the system clock.
******************************************************************************
* stm32f10x.h			Modify 118 lines of external crystal frequency
* system_stm32f10x.c	Modify 1055 lines of frequency doubling factor
#endif
******************************************************************************
*/

#define SOCKET_ID 0
#define ETHERNET_BUF_MAX_SIZE (1024 * 2)

/* network information */
wiz_NetInfo default_net_info = {
    .mac = {0x00, 0x08, 0xdc, 0x12, 0x22, 0x12},
    .ip = {192, 168, 1, 30},
    .gw = {192, 168, 1, 1},
    .sn = {255, 255, 255, 0},
    .dns = {8, 8, 8, 8},
    .dhcp = NETINFO_DHCP}; 
uint8_t ethernet_buf[ETHERNET_BUF_MAX_SIZE] = {0};
static uint16_t tcps_port = 8000;
static uint16_t udps_port = 5000;
static uint8_t tx_size[_WIZCHIP_SOCK_NUM_] = {4, 4, 2, 1, 1, 1, 1, 2};
static uint8_t rx_size[_WIZCHIP_SOCK_NUM_] = {4, 4, 2, 1, 1, 1, 1, 2};

int main(void)
{
	delay_init();
    debug_usart_init();
    wiz_timer_init();
    wiz_spi_init();
    wiz_rst_int_init();
    user_led_init();
    printf("%s UPnP example\r\n",_WIZCHIP_ID_);

	/* wizchip init */
	wizchip_initialize();

	network_init(ethernet_buf, &default_net_info);
	
	/* socket rx and tx buff init */
    wizchip_init(tx_size, rx_size);
		
    UserLED_Control_Init(set_user_led_status);
    
    do
    {
        printf("Send SSDP.. \r\n");
    } while (SSDPProcess(SOCKET_ID) != 0); // SSDP Search discovery

    if (GetDescriptionProcess(SOCKET_ID) == 0) // GET IGD description
    {
        printf("GetDescription Success!!\r\n");
    }
    else
    {
        printf("GetDescription Fail!!\r\n");
    }

    if (SetEventing(SOCKET_ID) == 0) // Subscribes IGD event messageS
    {
        printf("SetEventing Success!!\r\n");
    }
    else
    {
        printf("SetEventing Fail!!\r\n");
    }

    Main_Menu(SOCKET_ID, SOCKET_ID + 1, SOCKET_ID + 2, ethernet_buf, tcps_port, udps_port); // Main menu
    while (1)
    {
    }
}
