/**
  ******************************************************************************
  * @file    usb_desc.c
  * @author  NONE
  * @version NONE
  * @date    NONE
  * @brief   NONE
  ******************************************************************************/


/* Includes ------------------------------------------------------------------*/
#include "usb_desc.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Extern variables ----------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/* USB Standard Device Descriptor */
const uint8_t Joystick_DeviceDescriptor[JOYSTICK_SIZ_DEVICE_DESC] =
    {
        0x12,                       /*bLength */
        USB_DEVICE_DESCRIPTOR_TYPE, /*bDescriptorType*/
        0x00,                       /*bcdUSB */
        0x02,
        0x00,                       /*bDeviceClass*/
        0x00,                       /*bDeviceSubClass*/
        0x00,                       /*bDeviceProtocol*/
        0x40,                       /*bMaxPacketSize 64*/
        0x83,                       /*idVendor (0x0483)*/
        0x04,
        0x10,                       /*idProduct = 0x0010*/
        0x00,
        0x00,                       /*bcdDevice rel. 2.00*/
        0x02,
        1,                          /*Index of string descriptor describing
                                                  manufacturer */
        2,                          /*Index of string descriptor describing
                                                 product*/
        3,                          /*Index of string descriptor describing the
                                                 device serial number */
        0x01                        /*bNumConfigurations*/
}; /* Joystick_DeviceDescriptor */


/* USB Configuration Descriptor */
/*   All Descriptors (Configuration, Interface, Endpoint, Class, Vendor */
const uint8_t Joystick_ConfigDescriptor[JOYSTICK_SIZ_CONFIG_DESC] =
    {
        0x09,                              /* bLength: Configuration Descriptor size */
        USB_CONFIGURATION_DESCRIPTOR_TYPE, /* bDescriptorType: Configuration */
        JOYSTICK_SIZ_CONFIG_DESC,
        /* wTotalLength: Bytes returned */
        0x00,
        0x01, /*bNumInterfaces: 1 interface*/
        0x01, /*bConfigurationValue: Configuration value*/
        0x00, /*iConfiguration: Index of string descriptor describing
                                     the configuration*/
        0xE0, /*bmAttributes: Self powered */
        0x32, /*MaxPower 100 mA: this current is used for detecting Vbus*/

        /************** Descriptor of Joystick Mouse interface ****************/
        /* 09 */
        0x09,                          /*bLength: Interface Descriptor size*/
        USB_INTERFACE_DESCRIPTOR_TYPE, /*bDescriptorType: Interface descriptor type*/
        0x00,                          /*bInterfaceNumber: Number of Interface*/
        0x00,                          /*bAlternateSetting: Alternate setting*/
        0x01,                          /*bNumEndpoints*/
        0x03,                          /*bInterfaceClass: HID*/
        0x01,                          /*bInterfaceSubClass : 1=BOOT, 0=no boot*/
        0x01,                          /*nInterfaceProtocol : 0=none, 1=keyboard, 2=mouse*/
        0,                             /*iInterface: Index of string descriptor*/
        /******************** Descriptor of Joystick Mouse HID ********************/
        /* 18 */
        0x09,                     /*bLength: HID Descriptor size*/
        HID_DESCRIPTOR_TYPE,      /*bDescriptorType: HID*/
        0x00,                     /*bcdHID: HID Class Spec release number*/
        0x01,
        0x00,                     /*bCountryCode: Hardware target country*/
        0x01,                     /*bNumDescriptors: Number of HID class descriptors to follow*/
        0x22,                     /*bDescriptorType*/
        JOYSTICK_SIZ_REPORT_DESC, /*wItemLength: Total length of Report descriptor*/
        0x00,
        /******************** Descriptor of Joystick Mouse endpoint ********************/
        /* 27 */
        0x07,                         /*bLength: Endpoint Descriptor size*/
        USB_ENDPOINT_DESCRIPTOR_TYPE, /*bDescriptorType:*/

        0x81,                         /*bEndpointAddress: Endpoint Address (IN)*/
        0x03,                         /*bmAttributes: Interrupt endpoint*/
        0x08,                         /*wMaxPacketSize: 8 Byte max */
        0x00,
        0x20,                         /*bInterval: Polling Interval (32 ms)*/
                                      /* 34 */
}; /* MOUSE_ConfigDescriptor */
const uint8_t Joystick_ReportDescriptor[JOYSTICK_SIZ_REPORT_DESC] =
    {
        0x05, 0x01, /* Usage Page(Generic Desktop) */
        0x09, 0x06, /* Usage(Keyboard) */
        0xA1, 0x01, /* Collection(Application) */
        0x05, 0x07, /* Usage Page(Key Codes) */
        0x19, 0xE0, /* Usage Minimum(224) */
        0x29, 0xE7, /* Usage Maximum(231) */
        0x15, 0x00, /* Logical Minimum(0) */
        0x25, 0x01, /* Logical Maximum(1) */
        0x75, 0x01, /* Report Size(1) */
        0x95, 0x08, /* Report Count(8) */
        0x81, 0x02, /* Input(Data, Variable, Absolute), Modifier byte */
        0x95, 0x01, /* Report Count(1) */
        0x75, 0x08, /* Report Size(8) */
        0x81, 0x01, /* Input(Constant), Reserved byte */
        0x95, 0x05, /* Report Count(5) */
        0x75, 0x01, /* Report Size(1) */
        0x05, 0x08, /* Usage Page(LED) */
        0x19, 0x01, /* Usage Minimum(1) */
        0x29, 0x05, /* Usage Minimum(5) */
        0x91, 0x02, /* Output(Data, Variable, Absolute), LED report */
        0x95, 0x01, /* Report Count(1) */
        0x75, 0x03, /* Report Size(3) */
        0x91, 0x01, /* Output(Constant), LED report padding */
        0x95, 0x06, /* Report Count(6) */
        0x75, 0x08, /* Report Size(8) */
        0x15, 0x00, /* Logical Minimum(0) */
        0x25, 0x65, /* Logical Maximum(101) */
        0x05, 0x07, /* Usage Page(Key Codes) */
        0x19, 0x00, /* Usage Minimum(0) */
        0x29, 0x65, /* Usage Minimum(101) */
        0x81, 0x00, /* Input(Data, Array), Key arrays(6 bytes) */
        0xC0        /* End Collection */
}; /* Joystick_ReportDescriptor */

/* USB String Descriptors (optional) */
const uint8_t Joystick_StringLangID[JOYSTICK_SIZ_STRING_LANGID] =
    {
        JOYSTICK_SIZ_STRING_LANGID,
        USB_STRING_DESCRIPTOR_TYPE,
        0x09,
        0x04}; /* LangID = 0x0409: U.S. English */

const uint8_t Joystick_StringVendor[JOYSTICK_SIZ_STRING_VENDOR] =
    {
        JOYSTICK_SIZ_STRING_VENDOR, /* Size of Vendor string */
        USB_STRING_DESCRIPTOR_TYPE, /* bDescriptorType*/
        /* Manufacturer: "WIZnet" */
        'W', 0, 'I', 0, 'Z', 0, 'n', 0, 'e', 0, 't', 0};

const uint8_t Joystick_StringProduct[JOYSTICK_SIZ_STRING_PRODUCT] =
    {
        JOYSTICK_SIZ_STRING_PRODUCT, /* bLength */
        USB_STRING_DESCRIPTOR_TYPE,  /* bDescriptorType */
        'W', 0, 'I', 0, 'Z', 0, 'n', 0, 'e', 0, 't', 0, ' ', 0,
        'K', 0, 'e', 0, 'y', 0, 'b', 0, 'o', 0, 'r', 0, 'd', 0, ' ', 0, ' ', 0};
uint8_t Joystick_StringSerial[JOYSTICK_SIZ_STRING_SERIAL] =
    {
        JOYSTICK_SIZ_STRING_SERIAL, /* bLength */
        USB_STRING_DESCRIPTOR_TYPE, /* bDescriptorType */
        'W', 0, '5', 0, '5', 0, 'M', 0, 'H', 0, '3', 0, '2', 0, ' ', 0};

/******************* (C) COPYRIGHT  2024  WIZnet *****END OF FILE****/

