/**
  ******************************************************************************
  * @file    usb_desc.c
  * @author  NONE
  * @version NONE
  * @date    NONE
  * @brief   NONE
  ******************************************************************************/


/* Includes ------------------------------------------------------------------*/
#include "usb_lib.h"
#include "usb_desc.h"

/* USB Standard Device Descriptor */
const uint8_t Virtual_Com_Port_DeviceDescriptor[] =
    {
        0x12,                       /* bLength */
        USB_DEVICE_DESCRIPTOR_TYPE, /* bDescriptorType */
        0x00,
        0x02,                       /* bcdUSB = 2.00 */
        0x02,                       /* bDeviceClass: CDC */
        0x00,                       /* bDeviceSubClass */
        0x00,                       /* bDeviceProtocol */
        0x40,                       /* bMaxPacketSize0 */
        LOBYTE(USBD_VID),
        HIBYTE(USBD_VID),           /* idVendor = 0x0483 */
        LOBYTE(USBD_PID),
        HIBYTE(USBD_PID),           /* idProduct = 0x7540 */
        0x01,
        0x00,                       /* bcdDevice = 2.00 */
        1,                          /* Index of string descriptor describing manufacturer */
        2,                          /* Index of string descriptor describing product */
        3,                          /* Index of string descriptor describing the device's serial number */
        0x01                        /* bNumConfigurations */
};

const uint8_t Virtual_Com_Port_ConfigDescriptor[] =
    {
        /*Configuration Descriptor*/
        0x09,                              /* bLength: Configuration Descriptor size */
        USB_CONFIGURATION_DESCRIPTOR_TYPE, /* bDescriptorType: Configuration */
        VIRTUAL_COM_PORT_SIZ_CONFIG_DESC,  /* wTotalLength:no of returned bytes */
        0x00,
        0x01,                              /* bNumInterfaces: 1 interface */
        0x01,                              /* bConfigurationValue: Configuration value */
        0x00,                              /* iConfiguration: Index of string descriptor describing the configuration */
        0xC0,                              /* bmAttributes: self powered */
        0x00,                              /* MaxPower 0 mA */

        /*9 bytes Data  Interface Descriptor*/
        0x09,                          /* bLength: Interface Descriptor size */
        USB_INTERFACE_DESCRIPTOR_TYPE, /* bDescriptorType: Interface */
        /* Interface descriptor type */
        0x00, /* bInterfaceNumber: Number of Interface */
        0x00, /* bAlternateSetting: Alternate setting */
        0x02, /* bNumEndpoints: One endpoints used */
        0x07, /* bInterfaceClass: Communication Interface Class */
        0x01, /* bInterfaceSubClass: Abstract Control Model */
        0x02, /* bInterfaceProtocol: Common AT commands */
        0x00, /* iInterface: */

        /*18 bytes   Endpoint OUT Descriptor*/
        0x07,                         /* bLength: Endpoint Descriptor size */
        USB_ENDPOINT_DESCRIPTOR_TYPE, /* bDescriptorType: Endpoint */
        0x02,                         /* bEndpointAddress: (OUT3-EP2) */
        0x02,                         /* bmAttributes: Bulk */
        VIRTUAL_COM_PORT_DATA_SIZE,   /* wMaxPacketSize: */
        0x00,
        0x00,                         /* bInterval: ignore for Bulk transfer */

        /*25 bytes Endpoint 1 Descriptor*/
        0x07,                         /* bLength: Endpoint Descriptor size */
        USB_ENDPOINT_DESCRIPTOR_TYPE, /* bDescriptorType: Endpoint */
        0x81,                         /* bEndpointAddress: (IN1-EP0) */
        0x02,                         /* bmAttributes: Bulk */
        VIRTUAL_COM_PORT_DATA_SIZE,   /* wMaxPacketSize: */
        0x00,
        0x00,                         /* bInterval */

                                      /*32 bytes   Endpoint 2 Descriptor*/
        //0x07,   /* bLength: Endpoint Descriptor size */
        //USB_ENDPOINT_DESCRIPTOR_TYPE,   /* bDescriptorType: Endpoint */
        //0x03,   /* bEndpointAddress: (IN2) */
        //0x02,   /* bmAttributes: Interrupt */
        //VIRTUAL_COM_PORT_INT_SIZE,      /* wMaxPacketSize: */
        //0x00,
        //0x00,   /* bInterval: */
        /*offset39*/
};

/* USB String Descriptors */
const uint8_t Virtual_Com_Port_StringLangID[VIRTUAL_COM_PORT_SIZ_STRING_LANGID] =
    {
        VIRTUAL_COM_PORT_SIZ_STRING_LANGID,
        USB_STRING_DESCRIPTOR_TYPE,
        0x09,
        0x04 /* LangID = 0x0409: U.S. English */
};

const uint8_t Virtual_Com_Port_StringVendor[VIRTUAL_COM_PORT_SIZ_STRING_VENDOR] =
    {
        VIRTUAL_COM_PORT_SIZ_STRING_VENDOR, /* Size of Vendor string */
        USB_STRING_DESCRIPTOR_TYPE,         /* bDescriptorType*/
        /* Manufacturer: "WIZnet" */
        'W', 0, 'I', 0, 'Z', 0, 'n', 0, 'e', 0, 't', 0};

const uint8_t Virtual_Com_Port_StringProduct[VIRTUAL_COM_PORT_SIZ_STRING_PRODUCT] =
    {
        VIRTUAL_COM_PORT_SIZ_STRING_PRODUCT, /* bLength */
        USB_STRING_DESCRIPTOR_TYPE,          /* bDescriptorType */
        /* Product name: "WIZnet Printer" */
        'W', 0, 'I', 0, 'Z', 0, 'n', 0, 'e', 0, 't', 0,
        ' ', 0, 'P', 0, 'r', 0, 'i', 0, 'n', 0, 't', 0, 'e', 0, 'r', 0};

uint8_t Virtual_Com_Port_StringSerial[VIRTUAL_COM_PORT_SIZ_STRING_SERIAL] =
    {
        VIRTUAL_COM_PORT_SIZ_STRING_SERIAL, /* bLength */
        USB_STRING_DESCRIPTOR_TYPE,         /* bDescriptorType */
        'W', 0, '5', 0, '5', 0, 'M', 0, 'H', 0, '2', 0, '1', 0, '0', 0, '3', 0};

/************************ (C) COPYRIGHT  2024  WIZnet *****END OF FILE****/
