#include "debug.h"
#include "w55mh32.h"
#include "wiz_des.h"
#include "wiz_rand.h"
#include <stdio.h>
#include <string.h>


#define DES_TEST_LEN (64)
void DES_Func_Test() {
  uint8_t au8Plain[DES_TEST_LEN] = {
      0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
      0x17, 0x18, 0x19, 0x1A, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21,
      0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2b, 0x2c,
      0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
      0x38, 0x39, 0x3A, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40};
  uint8_t au8DESCipher_ECB[DES_TEST_LEN] = {
      0x77, 0xA7, 0xD6, 0xBC, 0xF5, 0x79, 0x62, 0xB9, 0xA3, 0x2D, 0x3D,
      0x85, 0x8F, 0xD3, 0xAF, 0xA6, 0x57, 0x51, 0xC8, 0xDE, 0x22, 0x62,
      0x85, 0xAA, 0x68, 0x7B, 0xC9, 0xEF, 0xFE, 0x26, 0xAF, 0x37, 0x00,
      0x3A, 0xC7, 0x91, 0x4A, 0x56, 0xDA, 0x27, 0x60, 0xFB, 0x12, 0xDF,
      0x2E, 0xFE, 0xDA, 0xC2, 0xB8, 0x6D, 0x92, 0xEB, 0xEE, 0xEC, 0x07,
      0xF0, 0xC6, 0x3F, 0xDF, 0x39, 0x8A, 0x3E, 0x8B, 0x04};
  uint8_t au8DESCipher_CBC[DES_TEST_LEN] = {
      0xB0, 0x73, 0xDC, 0x3F, 0xB2, 0x09, 0x53, 0x6D, 0x93, 0x95, 0x9F,
      0x07, 0x24, 0x23, 0x8E, 0x18, 0x25, 0xE2, 0xD1, 0xAB, 0xA7, 0x2B,
      0xAF, 0x3E, 0xE2, 0x9D, 0xDE, 0xCC, 0x32, 0x97, 0xBD, 0xEB, 0x51,
      0x95, 0x56, 0x58, 0x48, 0x5F, 0x87, 0x41, 0xDE, 0xF4, 0xEC, 0x91,
      0x0D, 0x65, 0x1C, 0x09, 0xC4, 0xF0, 0xFB, 0x2E, 0xDA, 0x5B, 0xCF,
      0x18, 0x90, 0xBB, 0x0B, 0x8C, 0x92, 0x85, 0x01, 0xD5};
  uint8_t au8Result[DES_TEST_LEN] = {0};
  uint8_t au8Iv[8] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
  uint8_t au8Key[8] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
  WIZ_SYM_CRYPT_CALL callDes;

  memset(&callDes, 0, sizeof(callDes));
  // ECB ENC
  callDes.pu8In = au8Plain;
  callDes.u32InLen = DES_TEST_LEN;
  callDes.pu8Out = au8Result;
  callDes.u32OutLen = DES_TEST_LEN;
  callDes.u16Opt = WIZ_DES_OPT_BLK_ECB | WIZ_DES_OPT_MODE_ENCRYPT;
  callDes.pu8Key = au8Key;
  callDes.u32Crc =
      WIZCRC_CalcBuff(0xffff, &callDes, sizeof(WIZ_SYM_CRYPT_CALL) - 4);
  WIZDES_EncDec(&callDes);
  r_printf((0 == memcmp(au8DESCipher_ECB, au8Result, DES_TEST_LEN)),
           "wiz_des_ecb test\n");

  // CBC DEC
  callDes.pu8In = au8DESCipher_CBC;
  callDes.u32InLen = DES_TEST_LEN;
  callDes.pu8Out = au8Result;
  callDes.u32OutLen = DES_TEST_LEN;
  callDes.pu8IV = au8Iv;
  callDes.u16Opt = WIZ_DES_OPT_BLK_CBC | WIZ_DES_OPT_MODE_DECRYPT;
  callDes.pu8Key = au8Key;
  callDes.u32Crc =
      WIZCRC_CalcBuff(0xffff, &callDes, sizeof(WIZ_SYM_CRYPT_CALL) - 4);
  WIZDES_EncDec(&callDes);
  r_printf((0 == memcmp(au8Plain, au8Result, DES_TEST_LEN)),
           "wiz_des_cbc test\n");
}

void DES_Test() { DES_Func_Test(); }

void TDES_Func_Test() {
  uint8_t au8Plain[DES_TEST_LEN] = {
      0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0b,
      0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
      0x17, 0x18, 0x19, 0x1A, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21,
      0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2b, 0x2c,
      0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
      0x38, 0x39, 0x3A, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40};
  uint8_t au8TDESCipher_ECB[DES_TEST_LEN] = {
      0x7D, 0x78, 0xD9, 0xC8, 0xFA, 0x35, 0xB9, 0x43, 0x6A, 0xF8, 0xCA,
      0x58, 0xAB, 0x3A, 0x35, 0x00, 0xAC, 0xBD, 0x15, 0x53, 0xE0, 0xC4,
      0x3C, 0x90, 0xF9, 0x5C, 0xE5, 0x97, 0xDE, 0xC4, 0xBF, 0x58, 0x96,
      0x9A, 0x18, 0x6D, 0xE8, 0x05, 0x92, 0x80, 0x16, 0x3A, 0xEC, 0x2B,
      0x30, 0x24, 0x37, 0x4E, 0x09, 0x2D, 0x46, 0x06, 0x3C, 0x61, 0xE9,
      0xAA, 0x21, 0x9C, 0xA8, 0xF6, 0x3F, 0x42, 0xE4, 0xD2};
  uint8_t au8TDESCipher_CBC[DES_TEST_LEN] = {
      0xAD, 0x17, 0xA7, 0x56, 0x3A, 0x0F, 0xF8, 0xF3, 0x47, 0xB6, 0x3E,
      0x78, 0x16, 0x72, 0xCD, 0xD7, 0x6F, 0x52, 0x02, 0x8E, 0xDB, 0x00,
      0x49, 0x39, 0x12, 0xD5, 0xB6, 0x8A, 0xD0, 0xCB, 0xDC, 0xC6, 0xFD,
      0x98, 0x82, 0x73, 0x18, 0x37, 0xCF, 0x9C, 0x68, 0x10, 0x2E, 0x94,
      0x8D, 0x85, 0x2E, 0x09, 0x81, 0x7F, 0x56, 0x70, 0x7E, 0x21, 0xCF,
      0x1B, 0x2D, 0x66, 0xD7, 0xE8, 0x96, 0xCC, 0xAC, 0xD4};
  uint8_t au8Result[DES_TEST_LEN] = {0};
  uint8_t au8Key[24] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
                        0x09, 0x0A, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10,
                        0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
  uint8_t au8Iv[8] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
  WIZ_SYM_CRYPT_CALL callTdes;

  memset(&callTdes, 0, sizeof(callTdes));
  // ECB ENC
  callTdes.pu8In = au8Plain;
  callTdes.u32InLen = DES_TEST_LEN;
  callTdes.pu8Out = au8Result;
  callTdes.u32OutLen = DES_TEST_LEN;
  callTdes.u16Opt =
      WIZ_DES_OPT_BLK_ECB | WIZ_DES_OPT_MODE_ENCRYPT | WIZ_TDES_OPT_KEY_3;
  callTdes.pu8Key = au8Key;
  callTdes.u32Crc =
      WIZCRC_CalcBuff(0xffff, &callTdes, sizeof(WIZ_SYM_CRYPT_CALL) - 4);
  WIZTDES_EncDec(&callTdes);
  r_printf((0 == memcmp(au8TDESCipher_ECB, au8Result, DES_TEST_LEN)),
           "wiz_tdes_ecb test\n");

  // CBC DEC
  callTdes.pu8In = au8TDESCipher_CBC;
  callTdes.u32InLen = DES_TEST_LEN;
  callTdes.pu8Out = au8Result;
  callTdes.u32OutLen = DES_TEST_LEN;
  callTdes.pu8IV = au8Iv;
  callTdes.u16Opt =
      WIZ_DES_OPT_BLK_CBC | WIZ_DES_OPT_MODE_DECRYPT | WIZ_TDES_OPT_KEY_3;
  callTdes.pu8Key = au8Key;
  callTdes.u32Crc =
      WIZCRC_CalcBuff(0xffff, &callTdes, sizeof(WIZ_SYM_CRYPT_CALL) - 4);
  WIZTDES_EncDec(&callTdes);
  r_printf((0 == memcmp(au8Plain, au8Result, DES_TEST_LEN)),
           "wiz_tdes_cbc test\n");
}

void TDES_Test() { TDES_Func_Test(); }
