#ifndef __I2C_EE_H
#define __I2C_EE_H

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "delay.h"
#include "w55mh32.h"
#include "bsp_i2c_gpio.h"


/* 
 * AT24C02 2kb = 2048bit = 2048/8 B = 256 B
 * 32 pages of 8 bytes each
 *
 * Device Address
 * 1 0 1 0 A2 A1 A0 R/W
 * 1 0 1 0 0  0  0  0 = 0XA0
 * 1 0 1 0 0  0  0  1 = 0XA1 
 */

/* AT24C01/02 Each page has eight bytes. 
 * AT24C04/08A/16A Each page has 16 bytes 
 */


#define EEPROM_DEV_ADDR  0xA0 /* 24xx02 device address */
#define EEPROM_PAGE_SIZE 8    /* 24xx02 page size */
#define EEPROM_SIZE      256  /* 24xx02 Total Capacity */


uint8_t ee_ReadBytes(uint8_t *_pReadBuf, uint16_t _usAddress, uint16_t _usSize);
uint8_t ee_WriteBytes(uint8_t *_pWriteBuf, uint16_t _usAddress, uint16_t _usSize);
uint8_t ee_CheckDevice(uint8_t _Address);
void    ee_Erase(void);
uint8_t ee_WaitStandby(void);
uint8_t ee_Test(void);


#endif /* __I2C_EE_H */
